<?php
// admin_landing.php
// This page serves as a custom landing page for administrators after login.
// It can provide an overview, quick links, or a welcoming message.

// Ensure session is started.
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Ensure the user is logged in AND is an admin or instructor.
// This page is part of the admin/instructor experience.
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || ($_SESSION['user_role'] !== 'admin' && $_SESSION['user_role'] !== 'instructor')) {
    header("Location: index.php?page=login"); // Redirect unauthorized users
    exit();
}

$username = $_SESSION['username'] ?? 'Administrator';
$user_role = $_SESSION['user_role'] ?? 'guest';

// You might fetch some summary data here for the landing page, e.g.,
// - Count of pending enrollments
// - Number of active courses
// - Number of students

// For now, it will be a welcoming page.
?>

<!-- Main content container for the admin landing page -->
<div class="w-full max-w-5xl mx-auto p-8 bg-white rounded-lg shadow-xl text-center">

    <h1 class="text-4xl font-extrabold text-gray-900 mb-6">
        Welcome to the Admin Panel, <span class="text-blue-700"><?php echo htmlspecialchars($username); ?></span>!
    </h1>
    <p class="text-xl text-gray-700 mb-8">
        You are logged in as an <span class="font-semibold capitalize text-blue-600"><?php echo htmlspecialchars($user_role); ?></span>.
    </p>

    <p class="text-gray-600 mb-10 leading-relaxed">
        This is your central hub for managing the LMS. From here, you can oversee student enrollments, manage course offerings, and handle user accounts.
    </p>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <a href="index.php?page=admin_dashboard" class="flex flex-col items-center justify-center p-6 bg-blue-100 rounded-lg shadow-md hover:bg-blue-200 transition duration-300">
            <svg class="w-12 h-12 text-blue-600 mb-3" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path></svg>
            <span class="text-lg font-semibold text-blue-800">Manage All Data</span>
            <span class="text-sm text-gray-600 mt-1">Courses, Enrollments, Users</span>
        </a>

        <a href="index.php?page=create_course" class="flex flex-col items-center justify-center p-6 bg-green-100 rounded-lg shadow-md hover:bg-green-200 transition duration-300">
            <svg class="w-12 h-12 text-green-600 mb-3" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm.707-10.293a1 1 0 00-1.414-1.414l-3 3a1 1 0 000 1.414l3 3a1 1 0 001.414-1.414L9.414 11H13a1 1 0 100-2H9.414l1.293-1.293z" clip-rule="evenodd"></path></svg>
            <span class="text-lg font-semibold text-green-800">Create New Course</span>
            <span class="text-sm text-gray-600 mt-1">Design and publish courses</span>
        </a>

        <?php if ($user_role === 'admin'): ?>
            <a href="index.php?page=register_student" class="flex flex-col items-center justify-center p-6 bg-purple-100 rounded-lg shadow-md hover:bg-purple-200 transition duration-300">
                <svg class="w-12 h-12 text-purple-600 mb-3" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path></svg>
                <span class="text-lg font-semibold text-purple-800">Manage Users</span>
                <span class="text-sm text-gray-600 mt-1">Register students & instructors</span>
            </a>
        <?php endif; ?>
    </div>

    <div class="mt-12">
        <p class="text-gray-500 text-sm">Need help? Contact support or refer to the documentation.</p>
    </div>

</div>
