<?php
// logout.php
// Handles user logout, including clearing the PHP session and the persistent login cookie.

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 🟢 STEP 1: Include the utility file to access the cookie clearing function
// Adjust the path if 'auth_utils.php' is in a different location relative to 'logout.php'
require_once 'includes/auth_utils.php'; 


// 🟢 STEP 2: Clear the Persistent Login Cookie (CRUCIAL)
// This removes the browser credential that triggers auto-login on the next request.
clear_persistent_cookie();


// 🟢 STEP 3: Destroy the PHP Session
// Clear all session variables
$_SESSION = array(); 

// Delete the session cookie from the browser
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroy the session data on the server
session_destroy();

// Redirect to the home page or login page after logout
header("Location: index.php?page=login"); // Recommended: redirect to login
exit();
?>