<?php
// student_profile.php
// Displays the student's profile details.

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || $_SESSION['user_role'] !== 'student') {
    header("Location: index.php?page=login");
    exit();
}

require_once 'config/database.php';

$user_id = $_SESSION['user_id'] ?? null;
$profile_data = null;
$message = '';
$is_error = false;

if ($user_id) {
    try {
        // Fetch student's profile data from the correct table and column
        $stmt = $pdo->prepare("
            SELECT 
                u.username,
                s.full_name,
                s.phone_number,
                s.address
            FROM users u
            JOIN student_profiles s ON u.id = s.user_id
            WHERE u.id = ?
        ");
        $stmt->execute([$user_id]);
        $profile_data = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$profile_data) {
            $message = "Profile not found.";
            $is_error = true;
        }

    } catch (PDOException $e) {
        $message = "Database error fetching profile: " . $e->getMessage();
        $is_error = true;
        error_log("Student Profile Fetch Error: " . $e->getMessage());
    }
} else {
    $message = "User ID not found in session.";
    $is_error = true;
}

?>
<div class="w-full max-w-2xl mx-auto p-6 bg-white rounded-lg shadow-xl">
    <div class="flex justify-between items-center mb-8 pb-4 border-b border-gray-200">
        <h1 class="text-3xl font-extrabold text-gray-900">My Profile</h1>
        <a href="index.php?page=edit_student_profile" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition duration-300">
            Edit Profile
        </a>
    </div>

    <?php if ($message && !$is_error): ?>
        <div class="mb-6 p-4 rounded-md text-center text-lg bg-blue-50 text-blue-700 border border-blue-200">
            <?php echo $message; ?>
        </div>
    <?php elseif ($is_error): ?>
        <div class="mb-6 p-4 rounded-md text-center text-lg bg-red-100 text-red-700 border border-red-200">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <?php if ($profile_data): ?>
        <div class="space-y-6">
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <span class="text-gray-600 font-semibold">Username:</span>
                <span class="text-gray-900 font-bold"><?php echo htmlspecialchars($profile_data['username']); ?></span>
            </div>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <span class="text-gray-600 font-semibold">Full Name:</span>
                <span class="text-gray-900"><?php echo htmlspecialchars($profile_data['full_name']); ?></span>
            </div>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <span class="text-gray-600 font-semibold">Phone Number:</span>
                <span class="text-gray-900"><?php echo htmlspecialchars($profile_data['phone_number']); ?></span>
            </div>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                <span class="text-gray-600 font-semibold">Address:</span>
                <span class="text-gray-900"><?php echo htmlspecialchars($profile_data['address']); ?></span>
            </div>
        </div>
    <?php endif; ?>
</div>